#!/usr/bin/env python
# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import sys
import gtk

def find_program_file(path):
    """Finds a program file, for example, a png included with the program.
    First looks for it in files/ under the parent directory of the parent directory
    of ear_candy.py
    Then looks for it in /usr/share/earcandy
    Returns the path of the file"""
    if os.path.exists(os.path.join(os.path.dirname(os.path.dirname(os.path.realpath(__file__))), "files",path)):
        return os.path.join(os.path.dirname(os.path.dirname(os.path.realpath(__file__))), "files",path)
    else:
        return os.path.join(sys.prefix, "share/earcandy", path)

class EarCandyStatusIcon(gtk.StatusIcon):
    def __init__(self, core):
        gtk.StatusIcon.__init__(self)
        self.core = core
        
        menu = '''
            <ui>
             <menubar name="Menubar">
              <menu action="Menu">
               <menuitem action="Preferences"/>
               <menuitem action="About"/>
               <separator/>
               <menuitem action="Exit"/>
              </menu>
             </menubar>
            </ui>
        '''
        actions = [
            ('Menu',  None, 'Menu'),
            ('Preferences', gtk.STOCK_PREFERENCES, '_Preferences...', None, 'Edit Preferences', self.on_preferences),
            ('About', gtk.STOCK_ABOUT, '_About...', None, 'About Ear Candy', self.on_about),
            ('Exit', gtk.STOCK_STOP, '_Exit...', None, 'Exit Ear Candy', self.stop)]
        ag = gtk.ActionGroup('Actions')
        ag.add_actions(actions)
        self.manager = gtk.UIManager()
        self.manager.insert_action_group(ag, 0)
        self.manager.add_ui_from_string(menu)
        self.menu = self.manager.get_widget('/Menubar/Menu/About').props.parent
        #self.set_from_icon_name("audio-volume-medium")
        self.set_icon()
        self.set_tooltip('Ear Candy volume manager')
        self.set_visible(True)
        self.connect('activate', self.on_activate)
        self.connect('popup-menu', self.on_popup_menu)

    def on_activate(self, data):

        if not self.core.slider.active:
            self.core.slider.window.set_position(gtk.WIN_POS_MOUSE)
            screen, rect, orin = self.get_geometry()           
            x, y = self.core.slider.window.get_position()
            if rect.y - rect.height/2 > y - rect.height:
                self.core.slider.window.move(x, y + rect.height)
            self.core.slider.run()
            
    def on_preferences(self, widget):
        self.core.open_preferances()

    def on_popup_menu(self, status, button, time):
        self.menu.popup(None, None, None, button, time)

    def on_about(self, data):
        dialog = gtk.AboutDialog()
        dialog.set_name('Ear Candy')
        dialog.set_version(str(self.core.version))
        dialog.set_comments('An pulseaudio / X.org sound manager')
        dialog.set_website('http://edge.launchpad.net/eyecandy')
        dialog.run()
        dialog.destroy()
    

    def set_icon(self):
        if self.core.active:
            icon_path = find_program_file("earsLabel.png")
        else:
            icon_path = find_program_file("earsLabelOff.png")
        self.set_from_file( icon_path )

    def stop(self, data=None):
        self.core.exit()
        
if __name__ == '__main__':
    ts = TrackerStatusIcon()
    ts.run()

